<?php
/**
 * Page de téléchargement du CRM FacturDash
 */

// Configuration du téléchargement
$downloadFile = '../crm.zip';
$fileName = 'FacturDash-CRM-v2.0.0.zip';

// Vérifier si le fichier existe
if (!file_exists($downloadFile)) {
    // Créer l'archive ZIP du CRM
    createCrmArchive();
}

// Fonction pour créer l'archive ZIP
function createCrmArchive() {
    $sourceDir = '../';
    $zipFile = '../crm.zip';
    
    // Exclure certains dossiers/fichiers
    $excludeFiles = [
        'presentation/',
        'crm.zip',
        '.git/',
        'node_modules/',
        '*.log',
        'config/installed.lock'
    ];
    
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
        addDirectoryToZip($zip, $sourceDir, '', $excludeFiles);
        $zip->close();
        
        return true;
    }
    
    return false;
}

// Fonction récursive pour ajouter les fichiers au ZIP
function addDirectoryToZip($zip, $sourceDir, $relativePath = '', $excludeFiles = []) {
    $iterator = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($sourceDir, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::SELF_FIRST
    );
    
    foreach ($iterator as $file) {
        $filePath = $file->getRealPath();
        $relativeFilePath = $relativePath . $file->getFilename();
        
        // Vérifier les exclusions
        $shouldExclude = false;
        foreach ($excludeFiles as $exclude) {
            if (fnmatch($exclude, $relativeFilePath) || strpos($relativeFilePath, $exclude) !== false) {
                $shouldExclude = true;
                break;
            }
        }
        
        if (!$shouldExclude) {
            if ($file->isDir()) {
                $zip->addEmptyDir($relativeFilePath);
            } else {
                $zip->addFile($filePath, $relativeFilePath);
            }
        }
    }
}

// Gérer le téléchargement
if (isset($_GET['download']) && $_GET['download'] === '1') {
    if (file_exists($downloadFile)) {
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . $fileName . '"');
        header('Content-Length: ' . filesize($downloadFile));
        header('Cache-Control: no-cache, must-revalidate');
        header('Expires: Sat, 26 Jul 1997 05:00:00 GMT');
        
        readfile($downloadFile);
        exit;
    } else {
        http_response_code(404);
        die('Fichier non trouvé');
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Télécharger FacturDash - CRM Complet</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="Téléchargez FacturDash, la solution de facturation moderne et conforme à la réglementation française">
    <meta name="keywords" content="télécharger, facturation, CRM, gestion clients, conformité française">
    <meta name="author" content="FacturDash">
    
    <!-- Cross-Browser Compatibility -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="format-detection" content="telephone=no">
    
    <!-- Fonts and Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzIiIGhlaWdodD0iMzIiIHZpZXdCb3g9IjAgMCAzMiAzMiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjMyIiBoZWlnaHQ9IjMyIiByeD0iNiIgZmlsbD0idXJsKCNncmFkaWVudCkiLz4KPHN2ZyB4PSI4IiB5PSI4IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAyNCAyNCIgZmlsbD0ibm9uZSI+CjxwYXRoIGQ9Ik0zIDEzVjExSDIxVjEzSDNaIiBzdHJva2U9IndoaXRlIiBzdHJva2Utd2lkdGg9IjIiIHN0cm9rZS1saW5lY2FwPSJyb3VuZCIgc3Ryb2tlLWxpbmVqb2luPSJyb3VuZCIvPgo8cGF0aCBkPSJNOSAxN0gxNVYxOUg5VjE3WiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+CjxkZWZzPgo8bGluZWFyR3JhZGllbnQgaWQ9ImdyYWRpZW50IiB4MT0iMCIgeTE9IjAiIHgyPSIzMiIgeTI9IjMyIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+CjxzdG9wIHN0b3AtY29sb3I9IiM2MzY2ZjEiLz4KPHN0b3Agb2Zmc2V0PSIxIiBzdG9wLWNvbG9yPSIjOGI1Y2Y2Ii8+CjwvbGluZWFyR3JhZGllbnQ+CjwvZGVmcz4KPC9zdmc+Cg==">
    <style>
        :root {
            --primary-color: #6366f1;
            --secondary-color: #8b5cf6;
            --accent-color: #ec4899;
            --success-color: #10b981;
            --danger-color: #f43f5e;
            --warning-color: #f59e0b;
            --background-color: #f8fafc;
            --text-color: #1e293b;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            color: var(--text-color);
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .download-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            padding: 3rem;
            box-shadow: 0 25px 50px -12px rgb(0 0 0 / 0.25);
            text-align: center;
            width: 100%;
        }

        .logo {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 1rem;
        }

        .title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
            color: var(--text-color);
        }

        .subtitle {
            font-size: 1.25rem;
            color: var(--gray-600);
            margin-bottom: 2rem;
        }

        .version-info {
            background: var(--gray-50);
            border-radius: 0.75rem;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border: 1px solid var(--gray-200);
        }

        .version-info h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: var(--text-color);
        }

        .version-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            text-align: left;
        }

        .version-detail {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--gray-600);
        }

        .version-detail i {
            color: var(--primary-color);
        }

        .download-button {
            display: inline-flex;
            align-items: center;
            gap: 0.75rem;
            background: linear-gradient(135deg, var(--success-color), #059669);
            color: white;
            padding: 1rem 2rem;
            border: none;
            border-radius: 0.75rem;
            font-size: 1.125rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            margin-bottom: 2rem;
            box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1);
            min-height: 44px; /* Minimum touch target size */
            min-width: 200px;
            justify-content: center;
        }

        .download-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1);
        }

        .features-list {
            background: var(--gray-50);
            border-radius: 0.75rem;
            padding: 1.5rem;
            margin-bottom: 2rem;
            text-align: left;
        }

        .features-list h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: var(--text-color);
            text-align: center;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem;
            border-radius: 0.5rem;
            background: white;
            border: 1px solid var(--gray-200);
        }

        .feature-item i {
            color: var(--success-color);
            font-size: 1.25rem;
        }

        .installation-steps {
            background: linear-gradient(135deg, #dbeafe, #bfdbfe);
            border-radius: 0.75rem;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border: 2px solid #3b82f6;
        }

        .installation-steps h3 {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1rem;
            color: #1e40af;
            text-align: center;
        }

        .steps-list {
            list-style: none;
            counter-reset: step-counter;
        }

        .steps-list li {
            counter-increment: step-counter;
            margin-bottom: 1rem;
            padding-left: 2rem;
            position: relative;
            color: #1e40af;
        }

        .steps-list li::before {
            content: counter(step-counter);
            position: absolute;
            left: 0;
            top: 0;
            background: #3b82f6;
            color: white;
            width: 1.5rem;
            height: 1.5rem;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.875rem;
            font-weight: 600;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }

        .back-link:hover {
            color: var(--secondary-color);
        }

        .file-size {
            font-size: 0.875rem;
            color: var(--gray-500);
            margin-top: 0.5rem;
        }

        @media (max-width: 768px) {
            .container {
                padding: 1rem;
            }
            
            .download-card {
                padding: 2rem;
            }
            
            .title {
                font-size: 2rem;
            }
            
            .subtitle {
                font-size: 1rem;
            }
            
            .version-details {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .version-item {
                padding: 1rem;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .feature-item {
                padding: 0.75rem;
                font-size: 0.9rem;
            }
            
            .installation-steps {
                padding: 1.5rem;
            }
            
            .steps-list {
                font-size: 0.9rem;
            }
            
            .download-button {
                width: 100%;
                padding: 1.25rem 2rem;
                font-size: 1rem;
                justify-content: center;
            }
        }

        @media (max-width: 480px) {
            .container {
                padding: 0.75rem;
            }
            
            .download-card {
                padding: 1.5rem;
            }
            
            .title {
                font-size: 1.75rem;
                margin-bottom: 1rem;
            }
            
            .subtitle {
                font-size: 0.9rem;
                margin-bottom: 1.5rem;
            }
            
            .version-details {
                gap: 0.75rem;
            }
            
            .version-item {
                padding: 0.75rem;
            }
            
            .version-label {
                font-size: 0.8rem;
            }
            
            .version-value {
                font-size: 0.9rem;
            }
            
            .features-grid {
                gap: 0.75rem;
            }
            
            .feature-item {
                padding: 0.5rem;
                font-size: 0.85rem;
            }
            
            .feature-item i {
                font-size: 1rem;
            }
            
            .installation-steps {
                padding: 1rem;
            }
            
            .installation-steps h3 {
                font-size: 1.1rem;
                margin-bottom: 1rem;
            }
            
            .steps-list {
                font-size: 0.85rem;
                padding-left: 1rem;
            }
            
            .steps-list li {
                margin-bottom: 0.5rem;
            }
            
            .download-btn {
                padding: 0.875rem 1.25rem;
                font-size: 0.9rem;
            }
            
            .back-link {
                font-size: 0.9rem;
            }
        }

        @media (max-width: 320px) {
            .container {
                padding: 0.5rem;
            }
            
            .download-card {
                padding: 1rem;
            }
            
            .title {
                font-size: 1.5rem;
            }
            
            .subtitle {
                font-size: 0.85rem;
            }
            
            .version-item {
                padding: 0.5rem;
            }
            
            .feature-item {
                padding: 0.375rem;
                font-size: 0.8rem;
            }
            
            .installation-steps {
                padding: 0.75rem;
            }
            
            .steps-list {
                font-size: 0.8rem;
            }
            
            .download-btn {
                padding: 0.75rem 1rem;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="download-card">
            <div class="logo">
                <i class="fas fa-chart-line"></i>
                FacturDash
            </div>
            
            <h1 class="title">Télécharger FacturDash</h1>
            <p class="subtitle">Solution complète de facturation avec conformité française intégrée</p>
            
            <div class="version-info">
                <h3>Version 2.0.0 - Septembre 2024</h3>
                <div class="version-details">
                    <div class="version-detail">
                        <i class="fas fa-calendar"></i>
                        <span>Dernière mise à jour : Septembre 2024</span>
                    </div>
                    <div class="version-detail">
                        <i class="fas fa-code"></i>
                        <span>PHP 8.0+ requis</span>
                    </div>
                    <div class="version-detail">
                        <i class="fas fa-database"></i>
                        <span>MySQL 5.7+ ou SQLite</span>
                    </div>
                    <div class="version-detail">
                        <i class="fas fa-shield-alt"></i>
                        <span>Conformité française intégrée</span>
                    </div>
                </div>
            </div>
            
            <a href="?download=1" class="download-button" onclick="trackDownload()">
                <i class="fas fa-download"></i>
                Télécharger le CRM (<?= file_exists($downloadFile) ? formatBytes(filesize($downloadFile)) : '~15 MB' ?>)
            </a>
            
            <div class="file-size">
                Format : ZIP | Installation automatique incluse
            </div>
            
            <div class="features-list">
                <h3>🎉 Nouveautés de cette version</h3>
                <div class="features-grid">
                    <div class="feature-item">
                        <i class="fas fa-shield-alt"></i>
                        <span>Conformité facturation électronique française</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-building"></i>
                        <span>Gestion multi-entreprises</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-id-card"></i>
                        <span>Numéros SIREN clients</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-file-invoice"></i>
                        <span>Nouvelles mentions obligatoires</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-cogs"></i>
                        <span>Installation guidée complète</span>
                    </div>
                    <div class="feature-item">
                        <i class="fas fa-mobile-alt"></i>
                        <span>Interface responsive améliorée</span>
                    </div>
                </div>
            </div>
            
            <div class="installation-steps">
                <h3>📋 Installation en 3 étapes</h3>
                <ol class="steps-list">
                    <li>Extrayez l'archive dans votre dossier web (WAMP, XAMPP, etc.)</li>
                    <li>Accédez à <code>http://votre-domaine/crm/install/</code></li>
                    <li>Suivez l'assistant d'installation guidé</li>
                </ol>
            </div>
            
            <a href="index.html" class="back-link">
                <i class="fas fa-arrow-left"></i>
                Retour à la présentation
            </a>
        </div>
    </div>

    <script>
        function trackDownload() {
            // Analytics ou tracking du téléchargement
            console.log('Téléchargement de FacturDash initié');
            
            // Optionnel : envoyer un événement de tracking
            if (typeof gtag !== 'undefined') {
                gtag('event', 'download', {
                    'event_category': 'CRM',
                    'event_label': 'FacturDash v2.0.0'
                });
            }
        }

        // Animation d'entrée
        document.addEventListener('DOMContentLoaded', function() {
            const card = document.querySelector('.download-card');
            card.style.opacity = '0';
            card.style.transform = 'translateY(30px)';
            
            setTimeout(() => {
                card.style.transition = 'all 0.6s ease-out';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100);
        });
    </script>
</body>
</html>

<?php
function formatBytes($size, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    for ($i = 0; $size > 1024 && $i < count($units) - 1; $i++) {
        $size /= 1024;
    }
    return round($size, $precision) . ' ' . $units[$i];
}
?>
