# 🌟 FacturDash - Site de Présentation

Ce dossier contient les fichiers pour le futur site internet de FacturDash.

## 📁 Contenu

- **`index.html`** - Page de présentation principale avec design moderne
- **`download.php`** - Page de téléchargement du CRM avec création automatique d'archive
- **`README.md`** - Ce fichier de documentation

## 🎨 Fonctionnalités de la présentation

### Page d'accueil (`index.html`)
- ✅ **Design moderne** avec dégradés et animations
- ✅ **Section Hero** avec tableau de bord interactif
- ✅ **Fonctionnalités** détaillées avec icônes
- ✅ **Section conformité** avec calendrier d'obligation
- ✅ **Section téléchargement** avec liens directs
- ✅ **Footer complet** avec liens utiles
- ✅ **Responsive design** pour tous les appareils
- ✅ **Animations scroll** et effets visuels

### Page de téléchargement (`download.php`)
- ✅ **Création automatique** de l'archive ZIP du CRM
- ✅ **Informations de version** détaillées
- ✅ **Liste des nouveautés** avec icônes
- ✅ **Instructions d'installation** en 3 étapes
- ✅ **Téléchargement sécurisé** avec headers appropriés
- ✅ **Exclusion automatique** des fichiers inutiles

## 🚀 Utilisation

### Pour tester localement
```bash
# Accéder à la présentation
http://localhost/crm/presentation/

# Accéder au téléchargement
http://localhost/crm/presentation/download.php
```

### Pour déployer sur un site web
1. Copiez le contenu du dossier `presentation/` sur votre serveur web
2. Modifiez les liens dans `download.php` pour pointer vers votre CRM
3. Configurez les exclusions de fichiers selon vos besoins

## 🎯 Avantages de cette approche

### Séparation claire
- ✅ **Présentation** séparée du CRM fonctionnel
- ✅ **Design professionnel** pour attirer les utilisateurs
- ✅ **Téléchargement direct** sans complexité

### Fonctionnalités avancées
- ✅ **Archive automatique** du CRM à jour
- ✅ **Exclusions intelligentes** (pas de fichiers de config, logs, etc.)
- ✅ **Informations de version** dynamiques
- ✅ **Tracking des téléchargements** (prêt pour analytics)

### Maintenance facile
- ✅ **Code modulaire** et bien documenté
- ✅ **Styles CSS** organisés et commentés
- ✅ **JavaScript** pour les interactions
- ✅ **PHP** pour la logique de téléchargement

## 📋 Personnalisation

### Couleurs et branding
Modifiez les variables CSS dans `:root` pour adapter les couleurs :
```css
:root {
    --primary-color: #6366f1;    /* Couleur principale */
    --secondary-color: #8b5cf6;  /* Couleur secondaire */
    --accent-color: #ec4899;     /* Couleur d'accent */
}
```

### Contenu
- **Titre** : Modifiez "FacturDash" dans les fichiers HTML
- **Description** : Adaptez les textes selon vos besoins
- **Fonctionnalités** : Ajoutez/modifiez les sections features
- **Liens** : Mettez à jour les URLs de téléchargement

### Exclusions de fichiers
Dans `download.php`, modifiez le tableau `$excludeFiles` :
```php
$excludeFiles = [
    'presentation/',
    'crm.zip',
    '.git/',
    'node_modules/',
    '*.log',
    'config/installed.lock'
];
```

## 🔧 Développement futur

### Améliorations possibles
- [ ] **Blog** intégré pour les actualités
- [ ] **Documentation** interactive
- [ ] **Démonstration** en ligne
- [ ] **Système de versions** avec historique
- [ ] **Téléchargements** par plateforme (Windows, Linux, macOS)
- [ ] **Intégration** avec des systèmes de paiement
- [ ] **Analytics** avancés

### SEO et performance
- [ ] **Meta tags** optimisés
- [ ] **Images** optimisées (WebP, lazy loading)
- [ ] **Sitemap** XML
- [ ] **Schema markup** pour les données structurées
- [ ] **CDN** pour les assets statiques

## 📞 Support

Pour toute question sur la présentation :
- **Design** : Modifiez les fichiers HTML/CSS
- **Fonctionnalités** : Adaptez le JavaScript
- **Téléchargement** : Configurez le PHP selon votre serveur

---

**FacturDash** - Solution de facturation moderne et conforme 🇫🇷
